/** @type {import('tailwindcss').Config} */
export default {
  content: ['./src/**/*.{astro,html,js,jsx,md,mdx,svelte,ts,tsx,vue}'],
  darkMode: 'class',
  theme: {
    extend: {
      colors: {
        'tok': {
          50: '#fff0f3',
          100: '#ffe0e6',
          200: '#ffc6d3',
          300: '#ff9db2',
          400: '#ff6389',
          500: '#fe2858',
          600: '#ed1144',
          700: '#c80937',
          800: '#a50b34',
          900: '#8c0e32',
          950: '#4e0117',
        },
        'cyber': {
          50: '#edfffe',
          100: '#c0fffd',
          200: '#81fffc',
          300: '#3afff9',
          400: '#00f5ec',
          500: '#00d9d2',
          600: '#00aeac',
          700: '#008a8a',
          800: '#056c6d',
          900: '#0a5a5b',
          950: '#003839',
        },
        'midnight': {
          50: '#f4f6fb',
          100: '#e8ecf6',
          200: '#ccd7ec',
          300: '#9fb5dc',
          400: '#6b8dc7',
          500: '#486fb0',
          600: '#375694',
          700: '#2d4578',
          800: '#293c64',
          900: '#273454',
          950: '#0f141f',
        }
      },
      fontFamily: {
        'display': ['Clash Display', 'system-ui', 'sans-serif'],
        'body': ['Satoshi', 'system-ui', 'sans-serif'],
        'mono': ['JetBrains Mono', 'monospace'],
      },
      animation: {
        'gradient': 'gradient 8s linear infinite',
        'float': 'float 6s ease-in-out infinite',
        'pulse-slow': 'pulse 4s cubic-bezier(0.4, 0, 0.6, 1) infinite',
        'shimmer': 'shimmer 2s linear infinite',
        'bounce-in': 'bounceIn 0.6s cubic-bezier(0.68, -0.55, 0.265, 1.55)',
        'slide-up': 'slideUp 0.5s ease-out',
        'fade-in': 'fadeIn 0.3s ease-out',
      },
      keyframes: {
        gradient: {
          '0%, 100%': { backgroundPosition: '0% 50%' },
          '50%': { backgroundPosition: '100% 50%' },
        },
        float: {
          '0%, 100%': { transform: 'translateY(0px)' },
          '50%': { transform: 'translateY(-20px)' },
        },
        shimmer: {
          '0%': { backgroundPosition: '-200% 0' },
          '100%': { backgroundPosition: '200% 0' },
        },
        bounceIn: {
          '0%': { transform: 'scale(0.3)', opacity: '0' },
          '50%': { transform: 'scale(1.05)' },
          '70%': { transform: 'scale(0.9)' },
          '100%': { transform: 'scale(1)', opacity: '1' },
        },
        slideUp: {
          '0%': { transform: 'translateY(20px)', opacity: '0' },
          '100%': { transform: 'translateY(0)', opacity: '1' },
        },
        fadeIn: {
          '0%': { opacity: '0' },
          '100%': { opacity: '1' },
        },
      },
      backgroundSize: {
        '300%': '300%',
      },
    },
  },
  plugins: [],
}


