# TikSave - TikTok Video Downloader

A modern, fast, and free TikTok video downloader built with Astro.js and Tailwind CSS.

![TikSave Preview](./preview.png)

## Features

- 🚀 **Lightning Fast** - Download videos in seconds
- 💧 **No Watermark** - Get clean videos without TikTok watermark
- 🎵 **MP3 Extraction** - Extract audio from any video
- 📱 **Mobile Friendly** - Works perfectly on any device
- 🌙 **Dark Mode** - Easy on the eyes with dark theme support
- ♾️ **Unlimited Downloads** - No daily limits or restrictions
- 🔒 **Privacy First** - No data collection or storage
- 📜 **Download History** - Track your recent downloads locally

## Tech Stack

- **Frontend**: [Astro.js](https://astro.build/) 4.x
- **Styling**: [Tailwind CSS](https://tailwindcss.com/) 3.x
- **Backend**: Astro API Routes (Node.js)
- **Hosting**: Vercel / Netlify / Any Node.js server

## Getting Started

### Prerequisites

- Node.js 18+ 
- npm, pnpm, or yarn

### Installation

1. Clone the repository:
```bash
git clone https://github.com/yourusername/tiksave.git
cd tiksave
```

2. Install dependencies:
```bash
npm install
```

3. Start the development server:
```bash
npm run dev
```

4. Open [http://localhost:4321](http://localhost:4321) in your browser.

### Building for Production

```bash
npm run build
```

The built files will be in the `dist/` directory.

### Deployment

#### Vercel
```bash
npx vercel
```

#### Netlify
```bash
npx netlify deploy --prod
```

#### Docker
```dockerfile
FROM node:20-alpine
WORKDIR /app
COPY package*.json ./
RUN npm ci
COPY . .
RUN npm run build
EXPOSE 4321
CMD ["node", "./dist/server/entry.mjs"]
```

## API Usage

### Download Video Info

```bash
POST /api/download
Content-Type: application/json

{
  "url": "https://www.tiktok.com/@username/video/1234567890"
}
```

#### Response

```json
{
  "id": "1234567890",
  "title": "Video Title",
  "description": "Video description...",
  "duration": 15,
  "thumbnail": "https://...",
  "author": {
    "unique_id": "username",
    "nickname": "Display Name",
    "avatar": "https://..."
  },
  "statistics": {
    "play_count": 1000000,
    "like_count": 50000,
    "comment_count": 1000,
    "share_count": 500
  },
  "video": {
    "no_watermark": "https://...",
    "watermark": "https://..."
  },
  "music": {
    "title": "Sound Title",
    "url": "https://..."
  }
}
```

## Supported URL Formats

- `https://www.tiktok.com/@username/video/1234567890`
- `https://vm.tiktok.com/ZMxxxxxx/`
- `https://www.tiktok.com/t/ZTxxxxxx/`
- `https://www.tiktok.com/v/1234567890`

## Legal Disclaimer

This tool is for personal use only. Please respect copyright laws and TikTok's Terms of Service. Do not redistribute downloaded content without permission from the original creator.

## Contributing

Contributions are welcome! Please feel free to submit a Pull Request.

## License

MIT License - see [LICENSE](LICENSE) for details.

---

Built with ❤️ by [Your Name](https://github.com/yourusername)


